/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x.Timestamp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.x.Timestamp.Accuracy;
import th.co.oga.security.pki.x.Timestamp.MessageImprint;
import th.co.oga.security.pki.x.XGeneralName;

public class TimestampTokenInfo
implements ASN1Value {
    public static final INTEGER VERSION = new INTEGER(1L);
    private INTEGER version;
    private OBJECT_IDENTIFIER tsaPolicy;
    private MessageImprint msgImprint;
    private INTEGER sn;
    private GeneralizedTime genTime;
    private Accuracy accuracy;
    private BOOLEAN ordering;
    private INTEGER nonce;
    private XGeneralName tsa;
    private SEQUENCE exts;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template TEMPLATE = new Template();

    protected TimestampTokenInfo(INTEGER v, OBJECT_IDENTIFIER tsaPol, MessageImprint mi, INTEGER sn, GeneralizedTime gTime, Accuracy accuracy, BOOLEAN ordering, INTEGER nc, XGeneralName tsaName, SEQUENCE ext) throws InvalidBERException {
        this.version = v;
        this.tsaPolicy = tsaPol;
        this.msgImprint = mi;
        this.sn = sn;
        this.genTime = gTime;
        this.accuracy = accuracy;
        this.ordering = ordering;
        this.nonce = nc;
        this.tsa = tsaName;
        this.exts = ext;
    }

    public byte[] getDigest() throws InvalidBERException {
        return this.msgImprint.getDigest();
    }

    public String getDigestAlgoOID() {
        return this.msgImprint.getOID();
    }

    public BigInteger getNonce() {
        if (this.nonce != null) {
            return this.nonce.abs();
        }
        return BigInteger.ZERO;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.version);
        seq.addElement((ASN1Value)this.tsaPolicy);
        seq.addElement((ASN1Value)this.msgImprint);
        seq.addElement((ASN1Value)this.sn);
        seq.addElement((ASN1Value)this.genTime);
        if (this.accuracy != null) {
            seq.addElement((ASN1Value)this.accuracy);
        }
        seq.addElement((ASN1Value)this.ordering);
        if (this.nonce != null) {
            seq.addElement((ASN1Value)this.nonce);
        }
        if (this.tsa != null) {
            seq.addElement((ASN1Value)this.tsa);
        }
        if (this.exts != null) {
            seq.addElement((ASN1Value)this.exts);
        }
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement((ASN1Template)OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement((ASN1Template)MessageImprint.getTemplate());
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement((ASN1Template)GeneralizedTime.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)Accuracy.getTemplate());
            this.seqt.addElement((ASN1Template)BOOLEAN.getTemplate(), (ASN1Value)new BOOLEAN(false));
            this.seqt.addOptionalElement(INTEGER.getTemplate());
            this.seqt.addOptionalElement(new Tag(0L), (ASN1Template)XGeneralName.getTemplate());
            this.seqt.addOptionalElement(new Tag(1L), (ASN1Template)SEQUENCE.getTemplate());
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            Accuracy accu = null;
            if (seq.elementAt(5) != null) {
                accu = (Accuracy)seq.elementAt(5);
            }
            INTEGER n = null;
            if (seq.elementAt(7) != null) {
                n = (INTEGER)seq.elementAt(7);
            }
            XGeneralName g = null;
            if (seq.elementAt(8) != null) {
                g = (XGeneralName)seq.elementAt(8);
            }
            SEQUENCE s = null;
            if (seq.elementAt(9) != null) {
                s = (SEQUENCE)seq.elementAt(9);
            }
            return new TimestampTokenInfo((INTEGER)seq.elementAt(0), (OBJECT_IDENTIFIER)seq.elementAt(1), (MessageImprint)seq.elementAt(2), (INTEGER)seq.elementAt(3), (GeneralizedTime)seq.elementAt(4), accu, (BOOLEAN)seq.elementAt(6), n, g, s);
        }
    }
}

