/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.OIDs;

public class XCertID
implements ASN1Value {
    private AlgorithmIdentifier hashAlgorithm;
    private OCTET_STRING issuerName;
    private OCTET_STRING issuerKey;
    private INTEGER sn;
    public static final Tag TAG = SEQUENCE.TAG;

    private XCertID() {
    }

    public XCertID(AlgorithmProfile algo, byte[] issuerName, byte[] issuerKey, String sn) throws IOException {
        this.hashAlgorithm = new AlgorithmIdentifier(new OBJECT_IDENTIFIER(algo.getOID()), null);
        this.issuerName = new OCTET_STRING(issuerName);
        this.issuerKey = new OCTET_STRING(issuerKey);
        this.sn = new INTEGER(sn);
    }

    XCertID(AlgorithmIdentifier algoId, OCTET_STRING issuerName, OCTET_STRING issuerKey, INTEGER sn) {
        this.hashAlgorithm = algoId;
        this.issuerName = issuerName;
        this.issuerKey = issuerKey;
        this.sn = sn;
    }

    public String getAlgoOID() {
        return OIDs.fromLongs(this.hashAlgorithm.getOID().getNumbers());
    }

    public byte[] getIssuerName() {
        return this.issuerName.toByteArray();
    }

    public byte[] getIssuerKey() {
        return this.issuerKey.toByteArray();
    }

    public String getSerialNumber() {
        return this.sn.toString();
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.hashAlgorithm);
        seq.addElement((ASN1Value)this.issuerName);
        seq.addElement((ASN1Value)this.issuerKey);
        seq.addElement((ASN1Value)this.sn);
        seq.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt = SEQUENCE.getTemplate();

        public Template() {
            this.seqt.addElement((ASN1Template)AlgorithmIdentifier.getTemplate());
            this.seqt.addElement((ASN1Template)OCTET_STRING.getTemplate());
            this.seqt.addElement((ASN1Template)OCTET_STRING.getTemplate());
            this.seqt.addElement(INTEGER.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            return new XCertID((AlgorithmIdentifier)seq.elementAt(0), (OCTET_STRING)seq.elementAt(1), (OCTET_STRING)seq.elementAt(2), (INTEGER)seq.elementAt(3));
        }
    }
}

