/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.NULL;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.x.XRevokedInfo;

public class XCertStatus
implements ASN1Value {
    private static Tag GOOD = new Tag(0L);
    private static Tag REVOKE = new Tag(1L);
    private static Tag UNKOWN = new Tag(2L);
    private Tag statusTag;
    private ASN1Value status;

    public XCertStatus() {
        this.statusTag = new Tag(2L);
        this.status = new NULL();
    }

    XCertStatus(Tag tag, ASN1Value status) {
        this.statusTag = tag;
        this.status = status;
    }

    public XCertStatus(NULL good) {
        this.statusTag = new Tag(0L);
        this.status = good;
    }

    public boolean getStatus() {
        return this.statusTag.equals((Object)GOOD) && this.status instanceof NULL;
    }

    public String getStatusText() {
        if (this.statusTag.equals((Object)GOOD)) {
            return "Certificate is good ";
        }
        if (this.statusTag.equals((Object)REVOKE)) {
            return ((XRevokedInfo)this.status).getReason();
        }
        return "Unkown status";
    }

    public Tag getTag() {
        return this.status.getTag();
    }

    public void encode(OutputStream ostream) throws IOException {
        CHOICE choice = new CHOICE(this.statusTag, this.status);
        choice.encode(ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.encode(ostream);
    }

    public static class Template
    implements ASN1Template {
        CHOICE.Template ctmp = CHOICE.getTemplate();

        public Template() {
            this.ctmp.addElement(new Tag(0L), (ASN1Template)NULL.getTemplate());
            this.ctmp.addElement(new Tag(1L), (ASN1Template)new XRevokedInfo.Template());
            this.ctmp.addElement(new Tag(2L), (ASN1Template)NULL.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return true;
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            CHOICE chc = (CHOICE)this.ctmp.decode(istream);
            return new XCertStatus(chc.getValue().getTag(), chc.getValue());
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            return this.decode(istream);
        }
    }
}

