/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.IA5String;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.Certification.Extension.EDIPartyName;
import th.co.oga.security.pki.Certification.Extension.ORAddress;
import th.co.oga.security.pki.Certification.Extension.OtherName;
import th.co.oga.security.pki.Certification.Extension.URIString;
import th.co.oga.security.pki.x.DirectoryName;

public class XGeneralName
implements ASN1Value {
    private ASN1Value val;
    private Tag tg;
    private static final Template TEMPLATE = new Template();

    public XGeneralName() {
    }

    private XGeneralName(ASN1Value val) {
        this(val.getTag(), val);
    }

    public XGeneralName(Tag tag, ASN1Value generalName) {
        this.val = generalName;
        this.tg = tag;
    }

    public ASN1Value getValue() {
        return this.val;
    }

    public String getData() throws InvalidBERException, URISyntaxException {
        String data = "";
        if (this.val instanceof URIString) {
            data = ((URIString)this.val).getData();
        } else if (this.val instanceof IA5String) {
            data = ((IA5String)this.val).toString();
        } else if (this.val instanceof OtherName) {
            data = ((OtherName)this.val).getData();
        } else if (this.val instanceof EDIPartyName) {
            data = ((EDIPartyName)this.val).getData();
        } else if (this.val instanceof ORAddress) {
            data = ((ORAddress)this.val).getData();
        } else if (this.val instanceof DirectoryName) {
            data = ((DirectoryName)this.val).getData();
        } else if (this.val instanceof OBJECT_IDENTIFIER) {
            data = ((OBJECT_IDENTIFIER)this.val).toString();
        } else {
            ANY any = (ANY)this.val;
            data = new String(any.getContents());
        }
        return data;
    }

    public String getURL() throws InvalidBERException, URISyntaxException {
        String data = null;
        if (this.val instanceof URIString) {
            data = ((URIString)this.val).getData();
        }
        return data;
    }

    public void setOtherName(ASN1Value val) {
        this.val = val;
        this.tg = new Tag(0L);
    }

    public void rfc822Name(ASN1Value val) {
        this.val = val;
        this.tg = new Tag(1L);
    }

    public void setDNSName(ASN1Value val) {
        this.val = val;
        this.tg = new Tag(2L);
    }

    public void setX400Address(ASN1Value val) {
        this.val = val;
        this.tg = new Tag(3L);
    }

    public void setDirectoryName(ASN1Value val) {
        this.val = val;
        this.tg = new Tag(4L);
    }

    public void setEDIPartyName(ASN1Value val) {
        this.val = val;
        this.tg = new Tag(5L);
    }

    public void setUniformResourceIdentifier(ASN1Value val) {
        this.val = val;
        this.tg = new Tag(6L);
    }

    public void setIPAddress(ASN1Value val) {
        this.val = val;
        this.tg = new Tag(7L);
    }

    public void setRegisteredID(ASN1Value val) {
        this.val = val;
        this.tg = new Tag(8L);
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.tg, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        this.val.encode((OutputStream)buff);
        ANY any = new ANY(this.val.getTag(), buff.toByteArray());
        buff.close();
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)any);
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return this.val.getTag();
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    /* synthetic */ XGeneralName(ASN1Value aSN1Value, XGeneralName xGeneralName) {
        this(aSN1Value);
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template cTP = CHOICE.getTemplate();

        public Template() {
            this.cTP.addElement(new Tag(0L), (ASN1Template)new OtherName.Template());
            this.cTP.addElement(new Tag(1L), (ASN1Template)new IA5String.Template());
            this.cTP.addElement(new Tag(2L), (ASN1Template)new IA5String.Template());
            this.cTP.addElement(new Tag(3L), (ASN1Template)new ORAddress.Template());
            this.cTP.addElement(new Tag(4L), (ASN1Template)new DirectoryName.Template());
            this.cTP.addElement(new Tag(5L), (ASN1Template)new EDIPartyName.Template());
            this.cTP.addElement(new Tag(6L), (ASN1Template)new URIString.Template());
            this.cTP.addElement(new Tag(7L), (ASN1Template)new OCTET_STRING.Template());
            this.cTP.addElement(new Tag(8L), (ASN1Template)new OBJECT_IDENTIFIER.Template());
        }

        public boolean tagMatch(Tag tag) {
            return this.cTP.tagMatch(tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            ANY any = (ANY)ANY.getTemplate().decode(istream);
            any.getContents();
            return new XGeneralName(ASN1Util.decode((ASN1Template)this.cTP, (byte[])any.getContents()), null);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            return this.decode(istream);
        }
    }
}

