/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cert.Extension;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.x.XCertID;

public class XRequest
implements ASN1Value {
    private XCertID reqCert;
    private SEQUENCE exts = new SEQUENCE();
    public static final Tag TAG = SEQUENCE.TAG;

    private XRequest() {
    }

    public XRequest(XCertID certId) throws IOException {
        this(certId, new SEQUENCE());
    }

    public XRequest(XCertID certId, Extension[] singleRequestExtensions) throws IOException {
        this.reqCert = certId;
        if (singleRequestExtensions != null) {
            int i = 0;
            while (i < singleRequestExtensions.length) {
                this.exts.addElement((ASN1Value)singleRequestExtensions[i]);
                ++i;
            }
        }
    }

    XRequest(XCertID certId, SEQUENCE singleRequestExtensions) {
        this.reqCert = certId;
        this.exts = singleRequestExtensions;
    }

    public XCertID getCertId() {
        return this.reqCert;
    }

    public Extension[] getExtensions() throws IOException, CertificateException, CertProfileException {
        Extension[] es = new Extension[this.exts.size()];
        int i = 0;
        while (i < this.exts.size()) {
            es[i] = (Extension)this.exts.elementAt(i);
            ++i;
        }
        return es;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.reqCert);
        if (this.exts.size() > 0) {
            seq.addElement((ASN1Value)new EXPLICIT(new Tag(0L), (ASN1Value)this.exts));
        }
        seq.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt;

        public Template() {
            SEQUENCE.Template est = SEQUENCE.getTemplate();
            est.addElement((ASN1Template)Extension.getTemplate());
            EXPLICIT.Template tmpl = EXPLICIT.getTemplate((Tag)new Tag(0L), (ASN1Template)est);
            this.seqt = SEQUENCE.getTemplate();
            this.seqt.addElement((ASN1Template)new XCertID.Template());
            this.seqt.addOptionalElement((ASN1Template)tmpl);
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            SEQUENCE es = new SEQUENCE();
            if (seq.elementAt(1) != null) {
                EXPLICIT exp = (EXPLICIT)seq.elementAt(1);
                es = (SEQUENCE)exp.getContent();
            }
            return new XRequest((XCertID)seq.elementAt(0), es);
        }
    }
}

