/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.x.DirectoryName;

public class XResponderID
implements ASN1Value {
    private static Tag BYNAME = new Tag(1L);
    private static Tag BYKEY = new Tag(2L);
    private Tag tag;
    private ASN1Value value;

    public XResponderID(byte[] keyHash) {
        this.tag = BYKEY;
        this.value = new OCTET_STRING(keyHash);
    }

    public XResponderID(DirectoryName dn) {
        this.tag = BYNAME;
        this.value = dn;
    }

    XResponderID(Tag tag, ASN1Value value) {
        this.tag = tag;
        this.value = value;
    }

    public Tag getTag() {
        return this.value.getTag();
    }

    public void encode(OutputStream ostream) throws IOException {
        CHOICE choice = new CHOICE(this.tag, this.value);
        choice.encode(ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.encode(ostream);
    }

    public static class Template
    implements ASN1Template {
        CHOICE.Template ctmp = CHOICE.getTemplate();

        public Template() {
            this.ctmp.addElement(new Tag(1L), (ASN1Template)new DirectoryName.Template());
            this.ctmp.addElement(new Tag(2L), (ASN1Template)OCTET_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return true;
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            CHOICE chc = (CHOICE)this.ctmp.decode(istream);
            return new XResponderID(chc.getValue().getTag(), chc.getValue());
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            return this.decode(istream);
        }
    }
}

