/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.OIDs;

public class XResponseBytes
implements ASN1Value {
    private OBJECT_IDENTIFIER type;
    private OCTET_STRING value;
    public static final Tag TAG = SEQUENCE.TAG;

    private XResponseBytes() {
    }

    public XResponseBytes(String oid, byte[] value) {
        this(new OBJECT_IDENTIFIER(oid), new OCTET_STRING(value));
    }

    XResponseBytes(OBJECT_IDENTIFIER type, OCTET_STRING value) {
        this.type = type;
        this.value = value;
    }

    public byte[] getContent() {
        return this.value.toByteArray();
    }

    public String getOID() {
        return OIDs.fromLongs(this.type.getNumbers());
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.type);
        seq.addElement((ASN1Value)this.value);
        seq.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt = SEQUENCE.getTemplate();

        public Template() {
            this.seqt.addElement((ASN1Template)OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement((ASN1Template)OCTET_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            return new XResponseBytes((OBJECT_IDENTIFIER)seq.elementAt(0), (OCTET_STRING)seq.elementAt(1));
        }
    }
}

