/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cert.Extension;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.x.DirectoryName;
import th.co.oga.security.pki.x.XResponderID;
import th.co.oga.security.pki.x.XSingleResponse;

public class XResponseData
implements ASN1Value {
    public static INTEGER V1 = new INTEGER(0L);
    public static INTEGER V2 = new INTEGER(1L);
    public static INTEGER V3 = new INTEGER(2L);
    private INTEGER version = V1;
    private XResponderID resID;
    private GeneralizedTime producedTime;
    private SEQUENCE responses = new SEQUENCE();
    private SEQUENCE resExts = new SEQUENCE();
    public static final Tag TAG = SEQUENCE.TAG;

    private XResponseData() {
    }

    public XResponseData(byte[] responderIDByKeyHash, GeneralizedTime prodTime, XSingleResponse[] responses, Extension[] extensions) {
        this(new XResponderID(responderIDByKeyHash), prodTime, responses, extensions);
    }

    public XResponseData(DirectoryName responderIDByDN, GeneralizedTime prodTime, XSingleResponse[] responses, Extension[] extensions) {
        this(new XResponderID(responderIDByDN), prodTime, responses, extensions);
    }

    public XResponseData(XResponderID resID, GeneralizedTime prodTime, XSingleResponse[] responses, Extension[] extensions) {
        this.version = V1;
        this.resID = resID;
        this.producedTime = prodTime;
        int i = 0;
        while (i < responses.length) {
            this.responses.addElement((ASN1Value)responses[i]);
            ++i;
        }
        i = 0;
        while (i < extensions.length) {
            this.resExts.addElement((ASN1Value)extensions[i]);
            ++i;
        }
    }

    XResponseData(INTEGER v, XResponderID resID, GeneralizedTime prodTime, SEQUENCE responses, SEQUENCE extns) {
        this.version = v;
        this.resID = resID;
        this.producedTime = prodTime;
        this.responses = responses;
        this.resExts = extns;
    }

    public Extension[] getExtensions() throws IOException, CertificateException, CertProfileException {
        Extension[] es = new Extension[this.resExts.size()];
        int i = 0;
        while (i < this.resExts.size()) {
            es[i] = (Extension)this.resExts.elementAt(i);
            ++i;
        }
        return es;
    }

    public XSingleResponse[] getRequests() throws IOException, CertificateException, CertProfileException {
        XSingleResponse[] es = new XSingleResponse[this.responses.size()];
        int i = 0;
        while (i < this.responses.size()) {
            es[i] = (XSingleResponse)this.responses.elementAt(i);
            ++i;
        }
        return es;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)new EXPLICIT(new Tag(0L), (ASN1Value)this.version));
        seq.addElement((ASN1Value)this.resID);
        seq.addElement((ASN1Value)this.producedTime);
        seq.addElement((ASN1Value)this.responses);
        if (this.resExts.size() > 0) {
            seq.addElement((ASN1Value)new EXPLICIT(new Tag(1L), (ASN1Value)this.resExts));
        }
        seq.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt;

        public Template() {
            EXPLICIT.Template versionTemp = EXPLICIT.getTemplate((Tag)new Tag(0L), (ASN1Template)INTEGER.getTemplate());
            EXPLICIT defVersion = new EXPLICIT(new Tag(0L), (ASN1Value)V1);
            SEQUENCE.Template est = SEQUENCE.getTemplate();
            est.addElement((ASN1Template)Extension.getTemplate());
            this.seqt = SEQUENCE.getTemplate();
            this.seqt.addElement((ASN1Template)versionTemp, (ASN1Value)defVersion);
            this.seqt.addElement((ASN1Template)new XResponderID.Template());
            this.seqt.addElement((ASN1Template)new GeneralizedTime.Template());
            this.seqt.addElement((ASN1Template)new SEQUENCE.OF_Template((ASN1Template)new XSingleResponse.Template()));
            this.seqt.addOptionalElement((ASN1Template)EXPLICIT.getTemplate((Tag)new Tag(1L), (ASN1Template)est));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            EXPLICIT vexp = (EXPLICIT)seq.elementAt(0);
            SEQUENCE rl = new SEQUENCE();
            if (seq.elementAt(4) != null) {
                EXPLICIT exp = (EXPLICIT)seq.elementAt(4);
                rl = (SEQUENCE)exp.getContent();
            }
            return new XResponseData((INTEGER)((EXPLICIT)seq.elementAt(0)).getContent(), (XResponderID)seq.elementAt(1), (GeneralizedTime)seq.elementAt(2), (SEQUENCE)seq.elementAt(3), rl);
        }
    }
}

