/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.x.CRL.CRLReason;

public class XRevokedInfo
implements ASN1Value {
    private GeneralizedTime revTime;
    private CRLReason reason;
    public static final Tag TAG = SEQUENCE.TAG;

    private XRevokedInfo() {
    }

    XRevokedInfo(GeneralizedTime time, CRLReason reason) {
        this.revTime = time;
        this.reason = reason;
    }

    public XRevokedInfo(Date revokedTime, int reasonCode) throws IOException {
        this(new GeneralizedTime(revokedTime), new CRLReason(reasonCode));
    }

    public String getReason() {
        return this.reason.getReasonText();
    }

    public Date getRevokedTime() {
        return this.revTime.toDate();
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.revTime);
        if (this.reason != null) {
            seq.addElement((ASN1Value)new EXPLICIT(new Tag(0L), (ASN1Value)this.reason));
        }
        seq.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt;

        public Template() {
            EXPLICIT.Template tmpl = EXPLICIT.getTemplate((Tag)new Tag(0L), (ASN1Template)CRLReason.getTemplate());
            this.seqt = SEQUENCE.getTemplate();
            this.seqt.addElement((ASN1Template)GeneralizedTime.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)tmpl);
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            CRLReason rs = null;
            if (seq.elementAt(2) != null) {
                EXPLICIT exp = (EXPLICIT)seq.elementAt(0);
                rs = (CRLReason)exp.getContent();
            }
            return new XRevokedInfo((GeneralizedTime)seq.elementAt(0), rs);
        }
    }
}

