/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.BitSet;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.OIDs;
import th.co.oga.security.pki.Transport.TransportPackageEncodingFailException;

public class XSignature
implements ASN1Value {
    private AlgorithmIdentifier algoId;
    private BIT_STRING signature;
    private SEQUENCE certs = new SEQUENCE();
    public static final Tag TAG = SEQUENCE.TAG;

    private XSignature() {
    }

    public XSignature(AlgorithmProfile algo, byte[] signature, CertProfile cer) throws IOException {
        this.algoId = new AlgorithmIdentifier(new OBJECT_IDENTIFIER(algo.getOID()), null);
        this.signature = new BIT_STRING(signature, 0);
        this.certs.addElement((ASN1Value)this.getCertificate(cer));
    }

    public XSignature(AlgorithmProfile algo, BitSet signature, CertProfile[] cers) throws IOException {
        this(algo.getOID(), signature, cers);
    }

    public XSignature(String oid, BitSet signature, CertProfile[] cers) throws IOException {
        this.algoId = new AlgorithmIdentifier(new OBJECT_IDENTIFIER(oid), null);
        this.signature = new BIT_STRING(signature, 7);
        if (cers != null) {
            int i = 0;
            while (i < cers.length) {
                this.certs.addElement((ASN1Value)this.getCertificate(cers[i]));
                ++i;
            }
        }
    }

    Certificate getCertificate(CertProfile cert) throws IOException {
        try {
            return (Certificate)Certificate.getTemplate().decode((InputStream)new ByteArrayInputStream(cert.getBytes()));
        }
        catch (CertPackageException e) {
            throw new TransportPackageEncodingFailException(e);
        }
        catch (InvalidBERException e) {
            throw new TransportPackageEncodingFailException((Exception)((Object)e));
        }
    }

    CertProfile getCertProfile(Certificate cer) throws IOException, CertificateException, CertProfileException {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        cer.encode((OutputStream)buff);
        return CertProfile.getInstance(buff.toByteArray());
    }

    XSignature(AlgorithmIdentifier algoId, BIT_STRING signature, SEQUENCE certs) {
        this.algoId = algoId;
        this.signature = signature;
        this.certs = certs;
    }

    public byte[] getSignature() {
        return this.signature.getBits();
    }

    public CertProfile[] getCerts() throws IOException, CertificateException, CertProfileException {
        CertProfile[] cers = new CertProfile[this.certs.size()];
        int i = 0;
        while (i < this.certs.size()) {
            cers[i] = this.getCertProfile((Certificate)this.certs.elementAt(i));
            ++i;
        }
        return cers;
    }

    public CertProfile getSignCertificate() throws IOException, CertificateException, CertProfileException, ASN1Exception {
        int i = 0;
        while (i < this.certs.size()) {
            CertProfile cp = this.getCertProfile((Certificate)this.certs.elementAt(i));
            if (!cp.isCA()) {
                return cp;
            }
            ++i;
        }
        return null;
    }

    public String getAlgoOID() {
        return OIDs.fromLongs(this.algoId.getOID().getNumbers());
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.algoId);
        seq.addElement((ASN1Value)this.signature);
        if (this.certs.size() > 0) {
            seq.addElement((ASN1Value)new EXPLICIT(new Tag(0L), (ASN1Value)this.certs));
        }
        seq.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt;

        public Template() {
            EXPLICIT.Template cerTemp = EXPLICIT.getTemplate((Tag)new Tag(0L), (ASN1Template)new SEQUENCE.OF_Template((ASN1Template)Certificate.getTemplate()));
            this.seqt = SEQUENCE.getTemplate();
            this.seqt.addElement((ASN1Template)AlgorithmIdentifier.getTemplate());
            this.seqt.addElement((ASN1Template)BIT_STRING.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)cerTemp);
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            SEQUENCE cers = new SEQUENCE();
            if (seq.elementAt(2) != null) {
                EXPLICIT exp = (EXPLICIT)seq.elementAt(0);
                cers = (SEQUENCE)exp.getContent();
            }
            return new XSignature((AlgorithmIdentifier)seq.elementAt(0), (BIT_STRING)seq.elementAt(1), cers);
        }
    }
}

