/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.TimeBase;
import org.mozilla.jss.asn1.UTCTime;
import org.mozilla.jss.util.Assert;

public class XSigningTime
implements ASN1Value {
    public static DateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private TimeBase asn1Time;
    private static final Template templateInstance = new Template();

    private XSigningTime() {
    }

    public XSigningTime(TimeBase t) {
        this.asn1Time = t;
    }

    public XSigningTime(Calendar calDate) {
        this.asn1Time = new UTCTime(calDate.getTime());
    }

    public Date getDate() {
        return this.asn1Time.toDate();
    }

    public String getText() {
        return DATE_FORMAT.format(this.getDate());
    }

    public byte[] getData() {
        return ASN1Util.encode((ASN1Value)this.asn1Time);
    }

    public Tag getTag() {
        return this.asn1Time.getTag();
    }

    public void encode(OutputStream ostream) throws IOException {
        this.asn1Time.encode(ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.asn1Time.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template choicet = new CHOICE.Template();

        public Template() {
            this.choicet.addElement((ASN1Template)UTCTime.getTemplate());
            this.choicet.addElement((ASN1Template)GeneralizedTime.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return this.choicet.tagMatch(tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            CHOICE choice = (CHOICE)this.choicet.decode(istream);
            return new XSigningTime((TimeBase)choice.getValue());
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            Assert._assert((boolean)this.tagMatch(implicitTag));
            return this.decode(istream);
        }
    }
}

