/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cert.Extension;
import th.co.oga.security.pki.x.XCertID;
import th.co.oga.security.pki.x.XCertStatus;

public class XSingleResponse
implements ASN1Value {
    private XCertID certId;
    private XCertStatus certStatus;
    private GeneralizedTime thisUpdate;
    private GeneralizedTime nextUpdate;
    private SEQUENCE exts = new SEQUENCE();
    public static final Tag TAG = SEQUENCE.TAG;

    private XSingleResponse() {
    }

    XSingleResponse(XCertID certId, XCertStatus certStatus, GeneralizedTime thisUpdate, GeneralizedTime nextUpdate, SEQUENCE seqExt) {
        this.certId = certId;
        this.certStatus = certStatus;
        this.thisUpdate = thisUpdate;
        this.nextUpdate = nextUpdate;
        this.exts = seqExt;
    }

    public boolean getStatus() {
        return this.certStatus.getStatus();
    }

    public String getStatusText() {
        return this.certStatus.getStatusText();
    }

    public long getNextUpdate() {
        if (this.nextUpdate != null) {
            return this.nextUpdate.toDate().getTime();
        }
        return 0L;
    }

    public long getUpdateTime() {
        if (this.thisUpdate != null) {
            return this.thisUpdate.toDate().getTime();
        }
        return 0L;
    }

    public XCertID getCertId() {
        return this.certId;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.certId);
        seq.addElement((ASN1Value)this.certStatus);
        seq.addElement((ASN1Value)this.thisUpdate);
        if (this.nextUpdate != null) {
            seq.addElement((ASN1Value)new EXPLICIT(new Tag(0L), (ASN1Value)this.nextUpdate));
        }
        if (this.nextUpdate != null) {
            seq.addElement((ASN1Value)new EXPLICIT(new Tag(1L), (ASN1Value)this.exts));
        }
        seq.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt;

        public Template() {
            SEQUENCE.Template est = SEQUENCE.getTemplate();
            est.addElement((ASN1Template)Extension.getTemplate());
            this.seqt = SEQUENCE.getTemplate();
            this.seqt.addElement((ASN1Template)new XCertID.Template());
            this.seqt.addElement((ASN1Template)new XCertStatus.Template());
            this.seqt.addElement((ASN1Template)GeneralizedTime.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)EXPLICIT.getTemplate((Tag)new Tag(0L), (ASN1Template)GeneralizedTime.getTemplate()));
            this.seqt.addOptionalElement((ASN1Template)EXPLICIT.getTemplate((Tag)new Tag(1L), (ASN1Template)est));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            GeneralizedTime gt = null;
            if (seq.elementAt(3) != null) {
                EXPLICIT exp = (EXPLICIT)seq.elementAt(3);
                gt = (GeneralizedTime)exp.getContent();
            }
            SEQUENCE rl = new SEQUENCE();
            if (seq.elementAt(4) != null) {
                EXPLICIT exp = (EXPLICIT)seq.elementAt(4);
                rl = (SEQUENCE)exp.getContent();
            }
            return new XSingleResponse((XCertID)seq.elementAt(0), (XCertStatus)seq.elementAt(1), (GeneralizedTime)seq.elementAt(2), gt, rl);
        }
    }
}

