/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.x;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cert.Extension;
import org.mozilla.jss.pkix.primitive.Name;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.x.XGeneralName;
import th.co.oga.security.pki.x.XRequest;

public class XTBSRequest
implements ASN1Value {
    public static INTEGER V1 = new INTEGER(0L);
    public static INTEGER V2 = new INTEGER(1L);
    public static INTEGER V3 = new INTEGER(2L);
    private INTEGER version = V1;
    private XGeneralName requestorName;
    private SEQUENCE reqList = new SEQUENCE();
    private SEQUENCE reqExts = new SEQUENCE();
    public static final Tag TAG = SEQUENCE.TAG;

    private XTBSRequest() {
    }

    public XTBSRequest(XRequest request) throws IOException, InvalidBERException {
        this(null, new XRequest[]{request}, null);
    }

    public XTBSRequest(Name reqName, XRequest request) throws IOException {
        this(reqName, new XRequest[]{request}, null);
    }

    public XTBSRequest(Name requestName, XRequest[] requests, Extension[] requestExtensions) throws IOException {
        if (requestName != null) {
            this.requestorName = new XGeneralName();
            this.requestorName.setDirectoryName((ASN1Value)requestName);
        }
        int i = 0;
        while (i < requests.length) {
            this.reqList.addElement((ASN1Value)requests[i]);
            ++i;
        }
        if (requestExtensions != null) {
            i = 0;
            while (i < requestExtensions.length) {
                this.reqExts.addElement((ASN1Value)requestExtensions[i]);
                ++i;
            }
        }
    }

    XTBSRequest(INTEGER ver, XGeneralName name, SEQUENCE reqList, SEQUENCE extns) {
        this.version = ver;
        this.requestorName = name;
        this.reqList = reqList;
        this.reqExts = extns;
    }

    public Extension[] getExtensions() throws IOException, CertificateException, CertProfileException {
        Extension[] es = new Extension[this.reqExts.size()];
        int i = 0;
        while (i < this.reqExts.size()) {
            es[i] = (Extension)this.reqExts.elementAt(i);
            ++i;
        }
        return es;
    }

    public XRequest[] getRequests() throws IOException, CertificateException, CertProfileException {
        XRequest[] es = new XRequest[this.reqList.size()];
        int i = 0;
        while (i < this.reqList.size()) {
            es[i] = (XRequest)this.reqList.elementAt(i);
            ++i;
        }
        return es;
    }

    public void addRequest(XRequest req) {
        this.reqList.addElement((ASN1Value)req);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)new EXPLICIT(new Tag(0L), (ASN1Value)this.version));
        if (this.requestorName != null) {
            seq.addElement((ASN1Value)new EXPLICIT(new Tag(1L), (ASN1Value)this.requestorName));
        }
        seq.addElement((ASN1Value)this.reqList);
        if (this.reqExts.size() > 0) {
            seq.addElement((ASN1Value)new EXPLICIT(new Tag(2L), (ASN1Value)this.reqExts));
        }
        seq.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        SEQUENCE.Template seqt;

        public Template() {
            EXPLICIT.Template versionTemp = EXPLICIT.getTemplate((Tag)new Tag(0L), (ASN1Template)INTEGER.getTemplate());
            EXPLICIT defVersion = new EXPLICIT(new Tag(0L), (ASN1Value)V1);
            SEQUENCE.Template est = SEQUENCE.getTemplate();
            est.addElement((ASN1Template)Extension.getTemplate());
            this.seqt = SEQUENCE.getTemplate();
            this.seqt.addElement((ASN1Template)versionTemp, (ASN1Value)defVersion);
            this.seqt.addOptionalElement((ASN1Template)EXPLICIT.getTemplate((Tag)new Tag(1L), (ASN1Template)XGeneralName.getTemplate()));
            this.seqt.addElement((ASN1Template)new SEQUENCE.OF_Template((ASN1Template)new XRequest.Template()));
            this.seqt.addOptionalElement((ASN1Template)EXPLICIT.getTemplate((Tag)new Tag(2L), (ASN1Template)est));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            XGeneralName gn = null;
            if (seq.elementAt(1) != null) {
                EXPLICIT exp = (EXPLICIT)seq.elementAt(1);
                gn = (XGeneralName)exp.getContent();
            }
            SEQUENCE rl = new SEQUENCE();
            if (seq.elementAt(3) != null) {
                EXPLICIT exp = (EXPLICIT)seq.elementAt(3);
                rl = (SEQUENCE)exp.getContent();
            }
            return new XTBSRequest((INTEGER)((EXPLICIT)seq.elementAt(0)).getContent(), gn, (SEQUENCE)seq.elementAt(2), rl);
        }
    }
}

