/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.utils;

public class SysEnv {
    public static String PLATEFORM_WINDOWS = "Windows";
    public static String PLATEFORM_UNIX = "Unix";
    public static String PLATEFORM_MAC = "Apple";
    public static String OS_WINDOWS = "WINDOWS";
    public static String OS_SOLARIS = "SOLARIS";
    public static String OS_LINUX = "LINUX";
    public static String OS_HPUX = "HP-UX";
    public static String OS_AIX = "AIX";
    public static String OS_MAC = "MACINTOSH";
    public static String PLATEFORM_WINDOWS_MEMBERS = OS_WINDOWS;
    public static String PLATEFORM_UNIX_MEMBERS = String.valueOf(OS_LINUX) + "," + OS_SOLARIS + "," + OS_HPUX + "," + OS_AIX;
    public static String PLATEFORM_MAC_MEMBERS = OS_MAC;
    public static String CRYPTOGA_HOME_ENV = System.getenv("CRYPTOGA_HOME");
    public static String CRYPTOGA_HOME = System.getProperty("oga.crypto.home");
    private String osName = "";
    public static String userName = System.getProperty("user.name");
    public static String userHome = System.getProperty("user.home");
    public static String userDir = System.getProperty("user.dir");
    public static String FS = System.getProperty("file.separator");
    public static String PS = System.getProperty("path.separator");
    public static String LS = System.getProperty("line.separator");

    public String getUser() {
        return userName;
    }

    public String getHome() {
        return userHome;
    }

    public String getWorkingRoom() {
        return userDir;
    }

    public static boolean isOS(String os) {
        return SysEnv.getOSName().equalsIgnoreCase(os);
    }

    public static String getOSName() {
        String os = new String(System.getProperty("os.name"));
        if (os.indexOf("Windows") > -1) {
            return OS_WINDOWS;
        }
        if (os.indexOf("Sun") > -1 || os.indexOf("Solaris") > -1) {
            return OS_SOLARIS;
        }
        if (os.indexOf("HP-UX") > -1 || os.indexOf("HP") > -1) {
            return OS_HPUX;
        }
        if (os.indexOf("AIX") > -1) {
            return OS_AIX;
        }
        if (os.indexOf("LINUX") > -1) {
            return OS_LINUX;
        }
        return OS_MAC;
    }

    public static String getPlateform() {
        String osName = SysEnv.getOSName();
        if (PLATEFORM_UNIX_MEMBERS.indexOf(osName) > -1) {
            return PLATEFORM_UNIX;
        }
        if (PLATEFORM_WINDOWS_MEMBERS.indexOf(osName) > -1) {
            return PLATEFORM_WINDOWS;
        }
        return PLATEFORM_MAC;
    }
}

