/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.utils.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import th.co.oga.security.utils.monitor.ProgressionEvent;
import th.co.oga.security.utils.monitor.ProgressionMonitor;
import th.co.oga.security.utils.monitor.ProgressionWorker;

public class OperationMonitor
extends JDialog
implements ProgressionMonitor {
    private static final long serialVersionUID = 1L;
    private JProgressBar bar;
    private ProgressionWorker worker;
    private JButton doneButton;
    private JButton stopButton;
    private JLabel operationText;

    public OperationMonitor(String title) {
        JFrame.setDefaultLookAndFeelDecorated(false);
        this.doneButton = new JButton("Done");
        this.stopButton = new JButton("Cancel");
        this.operationText = new JLabel();
        this.setTitle(title);
        this.setLocation(100, 100);
        JPanel mp = new JPanel(new BorderLayout());
        this.bar = new JProgressBar(1, 100);
        this.bar.setStringPainted(true);
        mp.add((Component)this.bar, "North");
        JPanel bp = new JPanel(new FlowLayout());
        this.stopButton.setActionCommand("Abort");
        this.stopButton.addActionListener(new ButtonAction());
        bp.add(this.stopButton);
        this.doneButton.setActionCommand("Done");
        this.doneButton.addActionListener(new ButtonAction());
        bp.add(this.doneButton);
        this.doneButton.setEnabled(false);
        mp.add((Component)bp, "Center");
        this.setContentPane(mp);
        this.operationText.setText("Initialization ...");
        mp.add((Component)this.operationText, "South");
        this.pack();
        this.setVisible(false);
    }

    public void addActionListener(ProgressionWorker worker) {
        this.worker = worker;
    }

    public void setLength(int min, int max) {
        this.bar.setMinimum(min);
        this.bar.setMaximum(max);
    }

    public void active() {
        this.monitorReset();
        this.setVisible(true);
    }

    public void deactive() {
        this.setVisible(false);
    }

    public void monitorReset() {
        this.bar.setValue(0);
    }

    public void progressionPerformed(ProgressionEvent e) {
        this.operationText.setText(e.getSender().getOperationName());
        this.bar.setValue(e.getProgressionCount());
        if (e.getState() == ProgressionEvent.DONE || e.getState() == ProgressionEvent.ABORT) {
            this.doneButton.setEnabled(true);
            this.stopButton.setEnabled(false);
        }
        this.setVisible(true);
    }

    class ButtonAction
    implements ActionListener {
        ButtonAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equalsIgnoreCase("Done")) {
                OperationMonitor.this.worker.stopPerformed(e);
            } else if (e.getActionCommand().equalsIgnoreCase("Abort")) {
                OperationMonitor.this.worker.abortPerformed(e);
            }
        }
    }
}

