/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import th.co.oga.security.xml.XMLConfigEngineException;
import th.co.oga.security.xml.XMLConfigFileBackupException;
import th.co.oga.security.xml.XMLConfigFileLoadException;
import th.co.oga.security.xml.XMLConfigFileManipulateException;
import th.co.oga.security.xml.XMLConfigFileNotFoundException;
import th.co.oga.security.xml.XMLConfigFilePreException;
import th.co.oga.security.xml.XMLNodeConversionException;
import th.co.oga.security.xml.XMLRecord;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public abstract class XMLConfigFile {
    protected Document doc;
    private String configFile;
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private Transformer transformer;
    private long lastModify;

    public XMLConfigFile(String configFile) throws XMLConfigFileNotFoundException, XMLConfigFileLoadException, XMLConfigEngineException {
        try {
            this.transformer = this.transformerFactory.newTransformer();
            this.transformer.setOutputProperty("media-type", "text/xml");
            this.transformer.setOutputProperty("version", "1.0");
            this.transformer.setOutputProperty("encoding", "UTF-8");
            this.transformer.setOutputProperty("method", "xml");
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("omit-xml-declaration", "no");
        }
        catch (TransformerConfigurationException te) {
            throw new XMLConfigEngineException(" Transformer ", te.toString());
        }
        File file = new File(configFile);
        if (!file.exists()) {
            throw new XMLConfigFileNotFoundException(configFile);
        }
        this.configFile = configFile;
        this.loadConfigFile(file);
    }

    public void refresh() throws XMLConfigFileNotFoundException, XMLConfigFileLoadException {
        File file = new File(this.configFile);
        if (!file.exists()) {
            throw new XMLConfigFileNotFoundException(this.configFile);
        }
        this.loadConfigFile(file);
    }

    public boolean isUpdate() {
        File file = new File(this.configFile);
        return file.exists() && this.lastModify < file.lastModified();
    }

    protected void addEmptyElement(String parent, String elementName) {
        NodeList parents = this.getNodeList(parent);
        int point = 0;
        while (point < parents.getLength()) {
            if (XMLUtils.nodeTypeIs((short)1, parents.item(point).getNodeType())) {
                parents.item(point).appendChild(XMLUtils.createElementNode(this.doc, elementName, " "));
                break;
            }
            ++point;
        }
    }

    protected void addElement(XMLRecord rec) throws XMLConfigFileManipulateException {
        NodeList parents = this.getNodeList(rec.getParentElementName());
        boolean done = false;
        try {
            int point = 0;
            while (point < parents.getLength()) {
                if (XMLUtils.nodeTypeIs((short)1, parents.item(point).getNodeType())) {
                    parents.item(point).appendChild(rec.getXMLNode(this.doc));
                    done = true;
                    break;
                }
                ++point;
            }
        }
        catch (XMLNodeConversionException e) {
            throw new XMLConfigFileManipulateException("Can not do function deleteElement " + e.toString());
        }
        if (!done) {
            throw new XMLConfigFileManipulateException("Can not done function addElement ,may can not find parent node .");
        }
    }

    protected void updElement(XMLRecord rec) throws XMLConfigFileManipulateException {
        NodeList parents = this.getNodeList(rec.getParentElementName());
        boolean done = false;
        try {
            int point = 0;
            while (point < parents.getLength()) {
                if (XMLUtils.nodeTypeIs((short)1, parents.item(point).getNodeType())) {
                    NodeList childs = parents.item(point).getChildNodes();
                    int i = 0;
                    while (i < childs.getLength()) {
                        if (XMLUtils.nodeTypeIs((short)1, childs.item(i).getNodeType()) && rec.isXMLNode(childs.item(i))) {
                            parents.item(point).replaceChild(rec.getXMLNode(this.doc), childs.item(i));
                            done = true;
                            break;
                        }
                        ++i;
                    }
                }
                ++point;
            }
        }
        catch (XMLNodeConversionException e) {
            throw new XMLConfigFileManipulateException("Can not do function updElement " + e.toString());
        }
        catch (XMLRecordDataException e) {
            throw new XMLConfigFileManipulateException("Can not do function updElement " + e.toString());
        }
        if (!done) {
            throw new XMLConfigFileManipulateException("Can not done function deleteElement ,may can not find the node to remove .");
        }
    }

    protected void deleteElement(XMLRecord rec) throws XMLConfigFileManipulateException {
        NodeList parents = this.getNodeList(rec.getParentElementName());
        boolean done = false;
        try {
            int point = 0;
            while (point < parents.getLength()) {
                if (XMLUtils.nodeTypeIs((short)1, parents.item(point).getNodeType())) {
                    NodeList childs = parents.item(point).getChildNodes();
                    int i = 0;
                    while (i < childs.getLength()) {
                        if (XMLUtils.nodeTypeIs((short)1, childs.item(i).getNodeType()) && rec.isXMLNode(childs.item(i))) {
                            parents.item(point).removeChild(childs.item(i));
                            done = true;
                            break;
                        }
                        ++i;
                    }
                }
                ++point;
            }
        }
        catch (XMLRecordDataException e) {
            throw new XMLConfigFileManipulateException("Can not do function deleteElement " + e.toString());
        }
        if (!done) {
            throw new XMLConfigFileManipulateException("Can not done function deleteElement ,may can not find the node to remove .");
        }
    }

    protected String beginUpdate() throws XMLConfigFilePreException {
        String manNumber = this.genManipulateNumber();
        try {
            this.preConfigFile(manNumber);
        }
        catch (IOException e) {
            throw new XMLConfigFilePreException(this.preConfigFileName(manNumber));
        }
        return manNumber;
    }

    protected String flushUpdate(String manNumber) throws XMLConfigFileBackupException, XMLConfigFilePreException, XMLConfigFileNotFoundException, XMLConfigEngineException {
        try {
            this.backupConfigFile(manNumber);
            this.releasePreConfigFile(manNumber);
        }
        catch (IOException e) {
            throw new XMLConfigFilePreException(this.preConfigFileName(manNumber));
        }
        return manNumber;
    }

    protected NodeList getNodeList(String elementName) {
        return this.doc.getElementsByTagName(elementName);
    }

    protected Node getParentNode(XMLRecord rec) throws XMLConfigFileManipulateException {
        int nodeCnt = 0;
        int pointer = 0;
        NodeList nodeList = this.getNodeList(rec.getParentElementName());
        int i = 0;
        while (i < nodeList.getLength()) {
            if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                pointer = i;
                ++nodeCnt;
            }
            ++i;
        }
        if (nodeCnt == 0) {
            throw new XMLConfigFileManipulateException("Parent node " + rec.getParentElementName() + " notfound");
        }
        if (nodeCnt > 1) {
            throw new XMLConfigFileManipulateException("To many Parent node " + rec.getParentElementName() + " found");
        }
        return nodeList.item(pointer);
    }

    private String genManipulateNumber() {
        return "" + Calendar.getInstance().getTimeInMillis();
    }

    private void preConfigFile(String manNumber) throws XMLConfigFilePreException, IOException {
        String preFileName = this.preConfigFileName(manNumber);
        File preFile = new File(preFileName);
        if (!preFile.createNewFile() || !preFile.canWrite()) {
            throw new XMLConfigFilePreException(preFileName);
        }
    }

    private void releasePreConfigFile(String manNumber) throws XMLConfigFilePreException, XMLConfigEngineException, IOException {
        String preFileName = this.preConfigFileName(manNumber);
        File preFile = new File(preFileName);
        FileOutputStream out = new FileOutputStream(preFile);
        DOMSource source = new DOMSource(this.doc);
        StreamResult result = new StreamResult(out);
        try {
            this.transformer.transform(source, result);
        }
        catch (TransformerException te) {
            throw new XMLConfigEngineException(" Tranformer Writer ", te.toString());
        }
        out.close();
        File newFile = new File(this.configFile);
        if (!preFile.renameTo(newFile)) {
            throw new XMLConfigFilePreException(preFileName);
        }
    }

    private void backupConfigFile(String manNumber) throws XMLConfigFileBackupException, XMLConfigFileNotFoundException {
        File file = new File(this.configFile);
        if (!file.exists()) {
            throw new XMLConfigFileNotFoundException(this.configFile);
        }
        String backupFile = this.backupConfigFileName(manNumber);
        if (!file.renameTo(new File(backupFile))) {
            throw new XMLConfigFileBackupException(backupFile);
        }
    }

    private void loadConfigFile(File file) throws XMLConfigFileLoadException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringElementContentWhitespace(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.doc = db.parse(file);
            this.lastModify = file.lastModified();
        }
        catch (Exception e) {
            throw new XMLConfigFileLoadException(this.configFile, e.toString());
        }
    }

    private String preConfigFileName(String manNumber) {
        return String.valueOf(this.configFile) + ".PRE_" + manNumber;
    }

    private String backupConfigFileName(String manNumber) {
        return String.valueOf(this.configFile) + ".BAK_" + manNumber;
    }
}

