/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    public static String nodeValue(Node pn) {
        if (pn == null) {
            return null;
        }
        Node cn = pn.getFirstChild();
        if (cn == null) {
            return null;
        }
        return cn.getNodeValue();
    }

    public static String nodeName(Node pn) {
        return pn.getNodeName();
    }

    public static String elementTag(String tagName, String value) {
        return "<" + tagName + ">" + value + "</" + tagName + ">";
    }

    public static String nodeExplorer(Node node, String tab, int level) {
        String rtn = "\r\n" + tab + "Level :" + level + " . " + "Node Name:" + node.getNodeName() + " Type:" + node.getNodeType() + "-" + XMLUtils.nodeTypeName(node) + " Value:" + node.getNodeValue();
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() > 0) {
            rtn = String.valueOf(rtn) + "\r\n" + tab + "Childs list :";
            int i = 0;
            while (i < nodeList.getLength()) {
                Node n = nodeList.item(i);
                rtn = String.valueOf(rtn) + XMLUtils.nodeExplorer(n, String.valueOf(tab) + "\t", level + 1);
                ++i;
            }
        }
        return rtn;
    }

    public static String nodeTypeName(Node node) {
        String type = "";
        Short nt = new Short(node.getNodeType());
        if (nt.compareTo(new Short(2)) == 0) {
            type = "ATTRIBUTE_NODE";
        } else if (nt.compareTo(new Short(4)) == 0) {
            type = "CDATA_SECTION_NODE";
        } else if (nt.compareTo(new Short(8)) == 0) {
            type = "COMMENT_NODE";
        } else if (nt.compareTo(new Short(11)) == 0) {
            type = "DOCUMENT_FRAGMENT_NODE";
        } else if (nt.compareTo(new Short(9)) == 0) {
            type = "DOCUMENT_NODE";
        } else if (nt.compareTo(new Short(10)) == 0) {
            type = "DOCUMENT_TYPE_NODE";
        } else if (nt.compareTo(new Short(1)) == 0) {
            type = "ELEMENT_NODE";
        } else if (nt.compareTo(new Short(6)) == 0) {
            type = "ENTITY_NODE";
        } else if (nt.compareTo(new Short(5)) == 0) {
            type = "ENTITY_REFERENCE_NODE";
        } else if (nt.compareTo(new Short(12)) == 0) {
            type = "NOTATION_NODE";
        } else if (nt.compareTo(new Short(7)) == 0) {
            type = "PROCESSING_INSTRUCTION_NODE";
        } else if (nt.compareTo(new Short(3)) == 0) {
            type = "TEXT_NODE";
        }
        return type;
    }

    public static boolean nodeTypeIs(short stdType, short valueType) {
        boolean rtn = false;
        try {
            Short stdNodeType = new Short(stdType);
            rtn = stdNodeType.compareTo(new Short(valueType)) == 0;
        }
        catch (NullPointerException e) {
            rtn = false;
        }
        return rtn;
    }

    public static Document createEmptyDocument() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.newDocument();
    }

    public static Node createElementNode(Document doc, String key, String value) {
        Element element = doc.createElement(key);
        element.appendChild(doc.createTextNode(value));
        return element;
    }

    public static void initXMLFile(File file, String cont) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(file);
        XMLUtils.insertXMLHeader(out);
        out.write(cont.getBytes());
        out.close();
    }

    public static void insertXMLHeader(OutputStream out) throws IOException {
        out.write("<?xml version='1.0' encoding='utf-8'?>\r\n".getBytes());
    }
}

