/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.Constants;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ExceptionThrower;
import com.sun.org.apache.bcel.internal.generic.FieldOrMethod;
import com.sun.org.apache.bcel.internal.generic.StackConsumer;
import com.sun.org.apache.bcel.internal.generic.StackProducer;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.TypedInstruction;
import java.util.StringTokenizer;

public abstract class InvokeInstruction
extends FieldOrMethod
implements ExceptionThrower,
TypedInstruction,
StackConsumer,
StackProducer {
    InvokeInstruction() {
    }

    protected InvokeInstruction(short opcode, int index) {
        super(opcode, index);
    }

    public int consumeStack(ConstantPoolGen cpg) {
        String signature = this.getSignature(cpg);
        Type[] args = Type.getArgumentTypes(signature);
        int sum = this.opcode == 184 ? 0 : 1;
        int n = args.length;
        int i = 0;
        while (i < n) {
            sum += args[i].getSize();
            ++i;
        }
        return sum;
    }

    public int produceStack(ConstantPoolGen cpg) {
        return this.getReturnType(cpg).getSize();
    }

    public Type getReturnType(ConstantPoolGen cpg) {
        return Type.getReturnType(this.getSignature(cpg));
    }

    public Type getType(ConstantPoolGen cpg) {
        return this.getReturnType(cpg);
    }

    public Type[] getArgumentTypes(ConstantPoolGen cpg) {
        return Type.getArgumentTypes(this.getSignature(cpg));
    }

    public String toString(ConstantPool cp) {
        Constant c = cp.getConstant(this.index);
        StringTokenizer tok = new StringTokenizer(cp.constantToString(c));
        return Constants.OPCODE_NAMES[this.opcode] + " " + tok.nextToken().replace('.', '/') + tok.nextToken();
    }

    public String getMethodName(ConstantPoolGen cpg) {
        return this.getName(cpg);
    }
}

