/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler;

import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.PUSH;
import com.sun.org.apache.xalan.internal.xsltc.compiler.AttributeValue;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Instruction;
import com.sun.org.apache.xalan.internal.xsltc.compiler.LiteralElement;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Parser;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SimpleAttributeValue;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SymbolTable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SyntaxTreeNode;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ClassGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MethodGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Type;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.TypeCheckError;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Util;
import com.sun.org.apache.xml.internal.serializer.ElemDesc;

final class LiteralAttribute
extends Instruction {
    private final String _name;
    private final AttributeValue _value;

    protected boolean contextDependent() {
        return this._value.contextDependent();
    }

    public void display(int indent) {
        this.indent(indent);
        Util.println("LiteralAttribute name=" + this._name + " value=" + this._value);
    }

    public AttributeValue getValue() {
        return this._value;
    }

    public String getName() {
        return this._name;
    }

    private boolean hasBadChars(String value) {
        char[] chars = value.toCharArray();
        int size = chars.length;
        int i = 0;
        while (i < size) {
            char ch = chars[i];
            if (ch < ' ' || '~' < ch || ch == '<' || ch == '>' || ch == '&' || ch == '\"') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        il.append(methodGen.loadHandler());
        il.append(new PUSH(cpg, this._name));
        this._value.translate(classGen, methodGen);
        SyntaxTreeNode parent = this.getParent();
        if (parent instanceof LiteralElement && ((LiteralElement)parent).allAttributesUnique()) {
            String attrValue;
            int flags = 0;
            boolean isHTMLAttrEmpty = false;
            ElemDesc elemDesc = ((LiteralElement)parent).getElemDesc();
            if (elemDesc != null) {
                if (elemDesc.isAttrFlagSet(this._name, 4)) {
                    flags |= 2;
                    isHTMLAttrEmpty = true;
                } else if (elemDesc.isAttrFlagSet(this._name, 2)) {
                    flags |= 4;
                }
            }
            if (this._value instanceof SimpleAttributeValue && !this.hasBadChars(attrValue = ((SimpleAttributeValue)this._value).toString()) && !isHTMLAttrEmpty) {
                flags |= 1;
            }
            il.append(new PUSH(cpg, flags));
            il.append(methodGen.uniqueAttribute());
        } else {
            il.append(methodGen.attribute());
        }
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        this._value.typeCheck(stable);
        this.typeCheckContents(stable);
        return Type.Void;
    }

    public LiteralAttribute(String name, String value, Parser parser, SyntaxTreeNode parent) {
        this._name = name;
        this.setParent(parent);
        this._value = AttributeValue.create(this, value, parser);
    }
}

