/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler;

import com.sun.org.apache.bcel.internal.generic.ANEWARRAY;
import com.sun.org.apache.bcel.internal.generic.BasicType;
import com.sun.org.apache.bcel.internal.generic.CHECKCAST;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.DUP_X1;
import com.sun.org.apache.bcel.internal.generic.GETFIELD;
import com.sun.org.apache.bcel.internal.generic.ICONST;
import com.sun.org.apache.bcel.internal.generic.INVOKEINTERFACE;
import com.sun.org.apache.bcel.internal.generic.INVOKESPECIAL;
import com.sun.org.apache.bcel.internal.generic.INVOKEVIRTUAL;
import com.sun.org.apache.bcel.internal.generic.InstructionConstants;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.NEW;
import com.sun.org.apache.bcel.internal.generic.NEWARRAY;
import com.sun.org.apache.bcel.internal.generic.PUSH;
import com.sun.org.apache.xalan.internal.xsltc.compiler.AbsolutePathPattern;
import com.sun.org.apache.xalan.internal.xsltc.compiler.ApplyTemplates;
import com.sun.org.apache.xalan.internal.xsltc.compiler.CallTemplate;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Choose;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Constants;
import com.sun.org.apache.xalan.internal.xsltc.compiler.If;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Number;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Otherwise;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Param;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Parser;
import com.sun.org.apache.xalan.internal.xsltc.compiler.QName;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Stylesheet;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SymbolTable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Template;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Text;
import com.sun.org.apache.xalan.internal.xsltc.compiler.ValueOf;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Variable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.VariableBase;
import com.sun.org.apache.xalan.internal.xsltc.compiler.When;
import com.sun.org.apache.xalan.internal.xsltc.compiler.XSLTC;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ClassGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ErrorMsg;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MethodGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Type;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.TypeCheckError;
import com.sun.org.apache.xalan.internal.xsltc.runtime.AttributeList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;

public abstract class SyntaxTreeNode
implements Constants {
    private Parser _parser;
    protected SyntaxTreeNode _parent;
    private Stylesheet _stylesheet;
    private Template _template;
    private final Vector _contents = new Vector(2);
    protected QName _qname;
    private int _line;
    protected AttributeList _attributes = null;
    private Hashtable _prefixMapping = null;
    protected static final SyntaxTreeNode Dummy = new AbsolutePathPattern(null);
    protected static final int IndentIncrement = 4;
    private static final char[] _spaces = "                                                       ".toCharArray();

    protected final int elementCount() {
        return this._contents.size();
    }

    protected int getImportPrecedence() {
        Stylesheet stylesheet = this.getStylesheet();
        if (stylesheet == null) {
            return Integer.MIN_VALUE;
        }
        return stylesheet.getImportPrecedence();
    }

    public final int getLineNumber() {
        if (this._line > 0) {
            return this._line;
        }
        SyntaxTreeNode parent = this.getParent();
        return parent != null ? parent.getLineNumber() : 0;
    }

    public SyntaxTreeNode() {
        this._line = 0;
        this._qname = null;
    }

    protected boolean contextDependent() {
        return true;
    }

    protected boolean dependentContents() {
        int n = this.elementCount();
        int i = 0;
        while (i < n) {
            SyntaxTreeNode item = (SyntaxTreeNode)this._contents.elementAt(i);
            if (item.contextDependent()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected final boolean hasContents() {
        return this.elementCount() > 0;
    }

    protected final boolean isDummy() {
        return this == Dummy;
    }

    public SyntaxTreeNode(int line) {
        this._line = line;
        this._qname = null;
    }

    public void display(int indent) {
        this.displayContents(indent);
    }

    protected void displayContents(int indent) {
        int n = this.elementCount();
        int i = 0;
        while (i < n) {
            SyntaxTreeNode item = (SyntaxTreeNode)this._contents.elementAt(i);
            item.display(indent);
            ++i;
        }
    }

    protected final void indent(int indent) {
        System.out.print(new String(_spaces, 0, indent));
    }

    protected final void setLineNumber(int line) {
        this._line = line;
    }

    public final Parser getParser() {
        return this._parser;
    }

    protected final void parseChildren(Parser parser) {
        Vector<QName> locals = null;
        int count = this._contents.size();
        int i = 0;
        while (i < count) {
            SyntaxTreeNode child = (SyntaxTreeNode)this._contents.elementAt(i);
            parser.getSymbolTable().setCurrentNode(child);
            child.parseContents(parser);
            QName varOrParamName = this.updateScope(parser, child);
            if (varOrParamName != null) {
                if (locals == null) {
                    locals = new Vector<QName>(2);
                }
                locals.addElement(varOrParamName);
            }
            ++i;
        }
        parser.getSymbolTable().setCurrentNode(this);
        if (locals != null) {
            int nLocals = locals.size();
            int i2 = 0;
            while (i2 < nLocals) {
                parser.removeVariable((QName)locals.elementAt(i2));
                ++i2;
            }
        }
    }

    public void parseContents(Parser parser) {
        this.parseChildren(parser);
    }

    protected void setParser(Parser parser) {
        this._parser = parser;
    }

    protected QName getQName() {
        return this._qname;
    }

    protected void setQName(QName qname) {
        this._qname = qname;
    }

    public Stylesheet getStylesheet() {
        if (this._stylesheet == null) {
            SyntaxTreeNode parent = this;
            while (parent != null) {
                if (parent instanceof Stylesheet) {
                    return (Stylesheet)parent;
                }
                parent = parent.getParent();
            }
            this._stylesheet = (Stylesheet)parent;
        }
        return this._stylesheet;
    }

    protected final SymbolTable getSymbolTable() {
        return this._parser == null ? null : this._parser.getSymbolTable();
    }

    protected final SyntaxTreeNode getParent() {
        return this._parent;
    }

    protected final SyntaxTreeNode lastChild() {
        if (this._contents.size() == 0) {
            return null;
        }
        return (SyntaxTreeNode)this._contents.lastElement();
    }

    protected final void addElement(SyntaxTreeNode element) {
        this._contents.addElement(element);
        element.setParent(this);
    }

    protected final void removeElement(SyntaxTreeNode element) {
        this._contents.remove(element);
        element.setParent(null);
    }

    protected final void setFirstElement(SyntaxTreeNode element) {
        this._contents.insertElementAt(element, 0);
        element.setParent(this);
    }

    protected void setParent(SyntaxTreeNode parent) {
        if (this._parent == null) {
            this._parent = parent;
        }
    }

    private boolean isAdaptiveRTF(SyntaxTreeNode node) {
        Vector contents = node.getContents();
        int i = 0;
        while (i < contents.size()) {
            SyntaxTreeNode item = (SyntaxTreeNode)contents.elementAt(i);
            if (!this.isTextElement(item, true)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isSimpleRTF(SyntaxTreeNode node) {
        Vector contents = node.getContents();
        int i = 0;
        while (i < contents.size()) {
            SyntaxTreeNode item = (SyntaxTreeNode)contents.elementAt(i);
            if (!this.isTextElement(item, false)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isTextElement(SyntaxTreeNode node, boolean doExtendedCheck) {
        if (node instanceof ValueOf || node instanceof Number || node instanceof Text) {
            return true;
        }
        if (node instanceof If) {
            return doExtendedCheck ? this.isAdaptiveRTF(node) : this.isSimpleRTF(node);
        }
        if (node instanceof Choose) {
            Vector contents = node.getContents();
            int i = 0;
            while (i < contents.size()) {
                SyntaxTreeNode item = (SyntaxTreeNode)contents.elementAt(i);
                if (!(item instanceof Text || (item instanceof When || item instanceof Otherwise) && (doExtendedCheck && this.isAdaptiveRTF(item) || !doExtendedCheck && this.isSimpleRTF(item)))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return doExtendedCheck && (node instanceof CallTemplate || node instanceof ApplyTemplates);
    }

    protected Template getTemplate() {
        if (this._template == null) {
            SyntaxTreeNode parent = this;
            while (parent != null && !(parent instanceof Template)) {
                parent = parent.getParent();
            }
            this._template = (Template)parent;
        }
        return this._template;
    }

    protected final XSLTC getXSLTC() {
        return this._parser.getXSLTC();
    }

    protected void setAttributes(AttributeList attributes) {
        this._attributes = attributes;
    }

    protected final Object elementAt(int pos) {
        return this._contents.elementAt(pos);
    }

    protected boolean hasAttribute(String qname) {
        return this._attributes != null && this._attributes.getValue(qname) != null;
    }

    protected final Enumeration elements() {
        return this._contents.elements();
    }

    protected Hashtable getPrefixMapping() {
        return this._prefixMapping;
    }

    protected void setPrefixMapping(Hashtable mapping) {
        this._prefixMapping = mapping;
    }

    protected final Vector getContents() {
        return this._contents;
    }

    protected Attributes getAttributes() {
        return this._attributes;
    }

    protected void compileResultTree(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        Stylesheet stylesheet = classGen.getStylesheet();
        boolean isSimple = this.isSimpleRTF(this);
        boolean isAdaptive = false;
        if (!isSimple) {
            isAdaptive = this.isAdaptiveRTF(this);
        }
        int rtfType = isSimple ? 0 : (isAdaptive ? 1 : 2);
        il.append(methodGen.loadHandler());
        String DOM_CLASS = classGen.getDOMClass();
        il.append(methodGen.loadDOM());
        int index = cpg.addInterfaceMethodref("com.sun.org.apache.xalan.internal.xsltc.DOM", "getResultTreeFrag", "(IIZ)Lcom/sun/org/apache/xalan/internal/xsltc/DOM;");
        il.append(new PUSH(cpg, 32));
        il.append(new PUSH(cpg, rtfType));
        il.append(new PUSH(cpg, stylesheet.callsNodeset()));
        il.append(new INVOKEINTERFACE(index, 4));
        il.append(InstructionConstants.DUP);
        index = cpg.addInterfaceMethodref("com.sun.org.apache.xalan.internal.xsltc.DOM", "getOutputDomBuilder", "()Lcom/sun/org/apache/xml/internal/serializer/SerializationHandler;");
        il.append(new INVOKEINTERFACE(index, 1));
        il.append(InstructionConstants.DUP);
        il.append(methodGen.storeHandler());
        il.append(methodGen.startDocument());
        this.translateContents(classGen, methodGen);
        il.append(methodGen.loadHandler());
        il.append(methodGen.endDocument());
        if (stylesheet.callsNodeset() && !DOM_CLASS.equals("com/sun/org/apache/xalan/internal/xsltc/DOM")) {
            index = cpg.addMethodref("com/sun/org/apache/xalan/internal/xsltc/dom/DOMAdapter", "<init>", "(Lcom/sun/org/apache/xalan/internal/xsltc/DOM;[Ljava/lang/String;[Ljava/lang/String;[I[Ljava/lang/String;)V");
            il.append(new NEW(cpg.addClass("com/sun/org/apache/xalan/internal/xsltc/dom/DOMAdapter")));
            il.append(new DUP_X1());
            il.append(InstructionConstants.SWAP);
            if (!stylesheet.callsNodeset()) {
                il.append(new ICONST(0));
                il.append(new ANEWARRAY(cpg.addClass("java.lang.String")));
                il.append(InstructionConstants.DUP);
                il.append(InstructionConstants.DUP);
                il.append(new ICONST(0));
                il.append(new NEWARRAY(BasicType.INT));
                il.append(InstructionConstants.SWAP);
                il.append(new INVOKESPECIAL(index));
            } else {
                il.append(InstructionConstants.ALOAD_0);
                il.append(new GETFIELD(cpg.addFieldref("com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet", "namesArray", "[Ljava/lang/String;")));
                il.append(InstructionConstants.ALOAD_0);
                il.append(new GETFIELD(cpg.addFieldref("com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet", "urisArray", "[Ljava/lang/String;")));
                il.append(InstructionConstants.ALOAD_0);
                il.append(new GETFIELD(cpg.addFieldref("com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet", "typesArray", "[I")));
                il.append(InstructionConstants.ALOAD_0);
                il.append(new GETFIELD(cpg.addFieldref("com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet", "namespaceArray", "[Ljava/lang/String;")));
                il.append(new INVOKESPECIAL(index));
                il.append(InstructionConstants.DUP);
                il.append(methodGen.loadDOM());
                il.append(new CHECKCAST(cpg.addClass(classGen.getDOMClass())));
                il.append(InstructionConstants.SWAP);
                index = cpg.addMethodref("com.sun.org.apache.xalan.internal.xsltc.dom.MultiDOM", "addDOMAdapter", "(Lcom/sun/org/apache/xalan/internal/xsltc/dom/DOMAdapter;)I");
                il.append(new INVOKEVIRTUAL(index));
                il.append(InstructionConstants.POP);
            }
        }
        il.append(InstructionConstants.SWAP);
        il.append(methodGen.storeHandler());
    }

    public abstract void translate(ClassGenerator var1, MethodGenerator var2);

    protected void translateContents(ClassGenerator classGen, MethodGenerator methodGen) {
        int n = this.elementCount();
        int i = 0;
        while (i < n) {
            SyntaxTreeNode item = (SyntaxTreeNode)this._contents.elementAt(i);
            item.translate(classGen, methodGen);
            ++i;
        }
        int i2 = 0;
        while (i2 < n) {
            if (this._contents.elementAt(i2) instanceof VariableBase) {
                VariableBase var = (VariableBase)this._contents.elementAt(i2);
                var.unmapRegister(methodGen);
            }
            ++i2;
        }
    }

    public abstract Type typeCheck(SymbolTable var1) throws TypeCheckError;

    protected Type typeCheckContents(SymbolTable stable) throws TypeCheckError {
        int n = this.elementCount();
        int i = 0;
        while (i < n) {
            SyntaxTreeNode item = (SyntaxTreeNode)this._contents.elementAt(i);
            item.typeCheck(stable);
            ++i;
        }
        return Type.Void;
    }

    protected String getAttribute(String qname) {
        if (this._attributes == null) {
            return "";
        }
        String value = this._attributes.getValue(qname);
        return value == null || value.equals("") ? "" : value;
    }

    protected String lookupNamespace(String prefix) {
        String uri = null;
        if (this._prefixMapping != null) {
            uri = (String)this._prefixMapping.get(prefix);
        }
        if (uri == null && this._parent != null) {
            uri = this._parent.lookupNamespace(prefix);
            if (prefix == "" && uri == null) {
                uri = "";
            }
        }
        return uri;
    }

    protected String lookupPrefix(String uri) {
        String prefix = null;
        if (this._prefixMapping != null && this._prefixMapping.contains(uri)) {
            Enumeration prefixes = this._prefixMapping.keys();
            while (prefixes.hasMoreElements()) {
                prefix = (String)prefixes.nextElement();
                String mapsTo = (String)this._prefixMapping.get(prefix);
                if (!mapsTo.equals(uri)) continue;
                return prefix;
            }
        } else if (this._parent != null) {
            prefix = this._parent.lookupPrefix(uri);
            if (uri == "" && prefix == null) {
                prefix = "";
            }
        }
        return prefix;
    }

    protected void addAttribute(String qname, String value) {
        this._attributes.add(qname, value);
    }

    protected void addPrefixMapping(String prefix, String uri) {
        if (this._prefixMapping == null) {
            this._prefixMapping = new Hashtable();
        }
        this._prefixMapping.put(prefix, uri);
    }

    protected QName updateScope(Parser parser, SyntaxTreeNode node) {
        if (node instanceof Variable) {
            Variable var = (Variable)node;
            parser.addVariable(var);
            return var.getName();
        }
        if (node instanceof Param) {
            Param param = (Param)node;
            parser.addParameter(param);
            return param.getName();
        }
        return null;
    }

    protected String getAttribute(String prefix, String localName) {
        return this.getAttribute(prefix + ':' + localName);
    }

    public SyntaxTreeNode(String uri, String prefix, String local) {
        this._line = 0;
        this.setQName(uri, prefix, local);
    }

    protected void setQName(String uri, String prefix, String localname) {
        this._qname = new QName(uri, prefix, localname);
    }

    protected void reportError(SyntaxTreeNode element, Parser parser, String errorCode, String message) {
        ErrorMsg error = new ErrorMsg(errorCode, (Object)message, element);
        parser.reportError(3, error);
    }

    protected void reportWarning(SyntaxTreeNode element, Parser parser, String errorCode, String message) {
        ErrorMsg error = new ErrorMsg(errorCode, (Object)message, element);
        parser.reportError(4, error);
    }
}

