/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler.util;

import com.sun.org.apache.bcel.internal.generic.LocalVariableGen;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ErrorMsg;

final class SlotAllocator {
    private int _firstAvailableSlot;
    private int _size = 8;
    private int _free = 0;
    private int[] _slotsTaken = new int[this._size];

    SlotAllocator() {
    }

    public void releaseSlot(LocalVariableGen lvg) {
        int size = lvg.getType().getSize();
        int slot = lvg.getIndex();
        int limit = this._free;
        int i = 0;
        while (i < limit) {
            if (this._slotsTaken[i] == slot) {
                int j = i + size;
                while (j < limit) {
                    this._slotsTaken[i++] = this._slotsTaken[j++];
                }
                this._free -= size;
                return;
            }
            ++i;
        }
        String state = "Variable slot allocation error(size=" + size + ", slot=" + slot + ", limit=" + limit + ")";
        ErrorMsg err = new ErrorMsg("INTERNAL_ERR", state);
        throw new Error(err.toString());
    }

    public void initialize(LocalVariableGen[] vars) {
        int length = vars.length;
        int slot = 0;
        int i = 0;
        while (i < length) {
            int size = vars[i].getType().getSize();
            int index = vars[i].getIndex();
            slot = Math.max(slot, index + size);
            ++i;
        }
        this._firstAvailableSlot = slot;
    }

    public int allocateSlot(Type type) {
        int size = type.getSize();
        int limit = this._free;
        int slot = this._firstAvailableSlot;
        int where = 0;
        if (this._free + size > this._size) {
            int[] array = new int[this._size *= 2];
            int j = 0;
            while (j < limit) {
                array[j] = this._slotsTaken[j];
                ++j;
            }
            this._slotsTaken = array;
        }
        while (where < limit) {
            if (slot + size <= this._slotsTaken[where]) {
                int j = limit - 1;
                while (j >= where) {
                    this._slotsTaken[j + size] = this._slotsTaken[j];
                    --j;
                }
                break;
            }
            slot = this._slotsTaken[where++] + 1;
        }
        int j = 0;
        while (j < size) {
            this._slotsTaken[where + j] = slot + j;
            ++j;
        }
        this._free += size;
        return slot;
    }
}

