/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.axes;

import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.ExpressionOwner;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.XPathVisitor;
import com.sun.org.apache.xpath.internal.axes.AxesWalker;
import com.sun.org.apache.xpath.internal.axes.FilterExprIteratorSimple;
import com.sun.org.apache.xpath.internal.axes.PathComponent;
import com.sun.org.apache.xpath.internal.axes.WalkingIterator;
import com.sun.org.apache.xpath.internal.compiler.Compiler;
import com.sun.org.apache.xpath.internal.objects.XNodeSet;
import com.sun.org.apache.xpath.internal.operations.Variable;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class FilterExprWalker
extends AxesWalker {
    private Expression m_expr;
    private transient XNodeSet m_exprObj;
    private boolean m_mustHardReset = false;
    private boolean m_canDetachNodeset = true;

    public int getAnalysisBits() {
        if (null != this.m_expr && this.m_expr instanceof PathComponent) {
            return ((PathComponent)((Object)this.m_expr)).getAnalysisBits();
        }
        return 0x4000000;
    }

    public int getAxis() {
        return this.m_exprObj.getAxis();
    }

    public int getNextNode() {
        if (null != this.m_exprObj) {
            int next = this.m_exprObj.nextNode();
            return next;
        }
        return -1;
    }

    public void detach() {
        super.detach();
        if (this.m_canDetachNodeset) {
            this.m_exprObj.detach();
        }
        this.m_exprObj = null;
    }

    public boolean isDocOrdered() {
        return this.m_exprObj.isDocOrdered();
    }

    public short acceptNode(int n) {
        try {
            if (this.getPredicateCount() > 0) {
                this.countProximityPosition(0);
                if (!this.executePredicates(n, this.m_lpi.getXPathContext())) {
                    return 3;
                }
            }
            return 1;
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    public void setRoot(int root) {
        super.setRoot(root);
        this.m_exprObj = FilterExprIteratorSimple.executeFilterExpr(root, this.m_lpi.getXPathContext(), this.m_lpi.getPrefixResolver(), this.m_lpi.getIsTopLevel(), this.m_lpi.m_stackFrame, this.m_expr);
    }

    public Expression getInnerExpression() {
        return this.m_expr;
    }

    public void setInnerExpression(Expression expr) {
        expr.exprSetParent(this);
        this.m_expr = expr;
    }

    public boolean deepEquals(Expression expr) {
        if (!super.deepEquals(expr)) {
            return false;
        }
        FilterExprWalker walker = (FilterExprWalker)expr;
        return this.m_expr.deepEquals(walker.m_expr);
    }

    public int getLastPos(XPathContext xctxt) {
        return this.m_exprObj.getLength();
    }

    public void callPredicateVisitors(XPathVisitor visitor) {
        this.m_expr.callVisitors(new filterExprOwner(), visitor);
        super.callPredicateVisitors(visitor);
    }

    public FilterExprWalker(WalkingIterator locPathIterator) {
        super(locPathIterator, 20);
    }

    public void init(Compiler compiler, int opPos, int stepType) throws TransformerException {
        super.init(compiler, opPos, stepType);
        switch (stepType) {
            case 24: 
            case 25: {
                this.m_mustHardReset = true;
            }
            case 22: 
            case 23: {
                this.m_expr = compiler.compile(opPos);
                this.m_expr.exprSetParent(this);
                if (!(this.m_expr instanceof Variable)) break;
                this.m_canDetachNodeset = false;
                break;
            }
            default: {
                this.m_expr = compiler.compile(opPos + 2);
                this.m_expr.exprSetParent(this);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FilterExprWalker clone = (FilterExprWalker)super.clone();
        if (null != this.m_exprObj) {
            clone.m_exprObj = (XNodeSet)this.m_exprObj.clone();
        }
        return clone;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        super.fixupVariables(vars, globalsSize);
        this.m_expr.fixupVariables(vars, globalsSize);
    }

    class filterExprOwner
    implements ExpressionOwner {
        public Expression getExpression() {
            return FilterExprWalker.this.m_expr;
        }

        public void setExpression(Expression exp) {
            exp.exprSetParent(FilterExprWalker.this);
            FilterExprWalker.this.m_expr = exp;
        }

        filterExprOwner() {
        }
    }
}

